<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<!-- Header Area -->
    <header class="main-header <?php echo esc_attr(poolcleaning_sticky_menu()); ?>">
    	<div class="container">
		<?php if ( function_exists( 'peccular_companion_activated' ) ) { ?>
			<button class="top-header-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".top-header"><i class="fa fa-ellipsis-v"></i></button>
		<?php } ?>	


			<?php 
				$topheader_phn = get_theme_mod('topheader_phn','+386 40 111 5555');
				$topheader_phnicon = get_theme_mod('topheader_phnicon','fa fa-phone');
				$header_icon1 = get_theme_mod('header_icon1','fa fa-facebook');
				$header_icon2 = get_theme_mod('header_icon2','fa fa-linkedin');
				$header_icon3 = get_theme_mod('header_icon3','fa fa-twitter');
				$header_icon4 = get_theme_mod('header_icon4','fa fa-youtube-play');

			?>
		

			
           <!-- Header -->
            <nav class="navbar navbar-expand-lg navbaroffcanvase">
            	<div class="row">
            		<div class="col-md-2 col-lg-2 col-sm-6">
						<div class="logo">
							<?php
							if(has_custom_logo())
								{	
									the_custom_logo();
								}
								else { 
								?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<h4 class="site-title">
										<?php 
											echo esc_html(bloginfo('name'));
										?>
									</h4>
								</a>	
							<?php 						
								}
							?>
							<?php
								$poolcleaning_site_desc = get_bloginfo( 'description');
								if ($poolcleaning_site_desc) : ?>
									<p class="site-description"><?php echo esc_html($poolcleaning_site_desc); ?></p>
							<?php endif; ?>
						</div>
					</div>

					<div class="col-md-6 col-lg-6 col-sm-6">
						<div class="navbar-menubar">
		                    <!-- Small Divice Menu-->
		                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','pool-cleaning'); ?>"> 
		                        <i class="fa fa-bars"></i>
		                    </button>
		                    <div class="collapse navbar-collapse navbar-menu">
			                    <button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','pool-cleaning'); ?>"> 
			                        <i class="fa fa-times"></i>
			                    </button> 
								<?php 
									wp_nav_menu( 
										array(  
											'theme_location' => 'primary_menu',
											'container'  => '',
											'container_id'    => '',
											'menu_class' => 'navbar-nav main-nav',
											'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
											'walker' => new WP_Bootstrap_Navwalker()
											 ) 
										);
								?>
		                    </div>
		                </div>
	                </div>

					<div class="col-md-2 col-lg-2 col-sm-6 padding-0">
		                <div class="row">
							<div class="col-md-2 col-lg-2 col-sm-2 col-space-icon">
								<i class="<?php echo apply_filters('poolcleaning_topheader', $topheader_phnicon); ?>" aria-hidden="true"></i>
							</div>
							<div class="col-md-10 col-lg-10 col-sm-10 col-space-content">
								<p class="poolcleaning-phone-label"><?php echo apply_filters('poolcleaning_topheader', $topheader_phn); ?></p>
							</div>
						</div>
	                </div>

					<div class="col-md-2 col-lg-2 col-sm-6 socials padding-0">
						<div>
							<i class="<?php echo apply_filters('poolcleaning_topheader', $header_icon1); ?>" aria-hidden="true"></i>
		                	<i class="<?php echo apply_filters('poolcleaning_topheader', $header_icon2); ?>" aria-hidden="true"></i>
		                	<i class="<?php echo apply_filters('poolcleaning_topheader', $header_icon3); ?>" aria-hidden="true"></i>
		                	<i class="<?php echo apply_filters('poolcleaning_topheader', $header_icon4); ?>" aria-hidden="true"></i>
		                </div>
	                </div>

            	</div>
            </nav>
        </div>
    </header>