<?php
function poolcleaning_header_settings( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	/*=========================================
	Header Settings Panel
	=========================================*/
	$wp_customize->add_panel( 
		'header_section', 
		array(
			'priority'      => 2,
			'capability'    => 'edit_theme_options',
			'title'			=> __('Header', 'pool-cleaning'),
		) 
	);

	
	/*=========================================
	Pool Cleaning Site Identity
	=========================================*/
	$wp_customize->add_section(
        'title_tagline',
        array(
        	'priority'      => 1,
            'title' 		=> __('Site Identity','pool-cleaning'),
			'panel'  		=> 'header_section',
		)
    );


	// header sitetitle Color
	$headersitetitlecolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_sitetitlecolor',
    	array(
			'default' => $headersitetitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_sitetitlecolor',
		array(
		    'label'   		=> __('Title Color','pool-cleaning'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// header sitetagline Color
	$headersitetaglinecolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_sitetaglinecolor',
    	array(
			'default' => $headersitetaglinecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_sitetaglinecolor',
		array(
		    'label'   		=> __('Tagline Color','pool-cleaning'),
		    'section'		=> 'title_tagline',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	/*=========================================
	Pool Cleaning header
	=========================================*/
	$wp_customize->add_section(
        'top_header',
        array(
        	'priority'      => 5,
            'title' 		=> __('Header','pool-cleaning'),
			'panel'  		=> 'header_section',
		)
    );	


	$wp_customize->add_setting('poolcleaning_reset_header_settings',array(
	  'sanitize_callback'   => 'sanitize_text_field'
	));
	$wp_customize->add_control(new poolcleaning_Reset_Custom_Control($wp_customize, 'pool_cleaning_reset_header_settings',array(
	  'type' => 'reset_control',
	   'priority' => 1,
	  'label' => __('Reset Header Settings', 'pool-cleaning'),
	  'description' => 'pool_cleaning_header_reset_settings',
	  'section' => 'top_header'
	)));



    $wp_customize->add_setting('poolcleaning_top_header_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new poolcleaning_Tab_Control($wp_customize, 'poolcleaning_top_header_tabs', array(
	   'section' => 'top_header',
	   'priority' => 2,
	   'buttons' => array(
	      array(
     		'name' => esc_html__('General', 'pool-cleaning'),
 			'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'hide_show_sticky',
            	'topheader_phn',
            	'topheader_phnicon',
            	'header_icon1',
            	'header_icon2',
            	'header_icon3',
            	'header_icon4'

            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'pool-cleaning'),
            'icon' => 'dashicons dashicons-art',
            'fields' => array(
            	'header_iconcolor',
				'header_iconbgcolor',
				'header_menucolor',
				'header_submenutextcolor',
				'header_submenubgcolor',
				'header_submenutexthovercolor',
				'header_submenubghovercolor',
				'header_phoneiconcolor',
				'header_phoneiconbgcolor',
				'header_phonetextcolor'
            ),
         )
	    
    	),
	)));


	// general

	
	// sticky header
	$wp_customize->add_setting( 'hide_show_sticky',array(
        'default' => false,
        'sanitize_callback' => 'poolcleaning_switch_sanitization'
   	) );
   	$wp_customize->add_control( new poolcleaning_Toggle_Switch_Custom_Control( $wp_customize, 'hide_show_sticky',array(
        'label' => __( 'Show Sticky Header','pool-cleaning' ),
        'section' => 'top_header'
   	)));


	// topheader Phone Number
	$topheaderphn = esc_html__('+386 40 111 5555', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'topheader_phn',
    	array(
			'default' => $topheaderphn,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phn',
		array(
		    'label'   		=> __('Phone Number','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);		


	// topheader phone number icon
	$topheaderphnicon = esc_html__('fa fa-phone', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'topheader_phnicon',
    	array(
			'default' => $topheaderphnicon,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'topheader_phnicon',
		array(
		    'label'   		=> __('Phone Number Icon','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);		




	


	// header icon 1
	$headericon1 = esc_html__('fa fa-phone', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_icon1',
    	array(
			'default' => $headericon1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 9,
		)
	);	

	$wp_customize->add_control( 
		'header_icon1',
		array(
		    'label'   		=> __('Header Icon 1','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	


	// header icon 2
	$headericon2 = esc_html__('fa fa-envelope-o', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_icon2',
    	array(
			'default' => $headericon2,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 10,
		)
	);	

	$wp_customize->add_control( 
		'header_icon2',
		array(
		    'label'   		=> __('Header Icon 2','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	

	// header icon 3
	$headericon3 = esc_html__('fa fa-envelope-o', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_icon3',
    	array(
			'default' => $headericon3,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_icon3',
		array(
		    'label'   		=> __('Header Icon 3','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	


	// header icon 4
	$headericon4 = esc_html__('fa fa-youtube-play', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_icon4',
    	array(
			'default' => $headericon4,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_icon4',
		array(
		    'label'   		=> __('Header Icon 4','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'icon',
			'transport'         => $selective_refresh,
		)  
	);	


	// header Icon Color
	$headericoncolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_iconcolor',
    	array(
			'default' => $headericoncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_iconcolor',
		array(
		    'label'   		=> __('Icon Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	
	
	// header Iconbg Color
	$headericonbgcolor = esc_html__('#012e8a', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_iconbgcolor',
    	array(
			'default' => $headericonbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_iconbgcolor',
		array(
		    'label'   		=> __('Icon BG Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header menu Color
	$headermenucolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_menucolor',
    	array(
			'default' => $headermenucolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_menucolor',
		array(
		    'label'   		=> __('Menu Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header submenutext Color
	$headersubmenutextcolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_submenutextcolor',
    	array(
			'default' => $headersubmenutextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutextcolor',
		array(
		    'label'   		=> __('SubMenu Text Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header submenubg Color
	$headersubmenubgcolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_submenubgcolor',
    	array(
			'default' => $headersubmenubgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_submenubgcolor',
		array(
		    'label'   		=> __('SubMenu BG Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header submenutexthover Color
	$headersubmenutexthovercolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_submenutexthovercolor',
    	array(
			'default' => $headersubmenutexthovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_submenutexthovercolor',
		array(
		    'label'   		=> __('SubMenu Text Hover Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header submenubghover Color
	$headersubmenubghovercolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_submenubghovercolor',
    	array(
			'default' => $headersubmenubghovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_submenubghovercolor',
		array(
		    'label'   		=> __('SubMenu BG Hover Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header phoneicon Color
	$headerphoneiconcolor = esc_html__('#f4fbfb', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_phoneiconcolor',
    	array(
			'default' => $headerphoneiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_phoneiconcolor',
		array(
		    'label'   		=> __('Phone Icon Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header phoneiconbg Color
	$headerphoneiconbgcolor = esc_html__('#1da4ea', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_phoneiconbgcolor',
    	array(
			'default' => $headerphoneiconbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_phoneiconbgcolor',
		array(
		    'label'   		=> __('Phone Icon BG Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// header phonetext Color
	$headerphonetextcolor = esc_html__('#d5dce7', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'header_phonetextcolor',
    	array(
			'default' => $headerphonetextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'header_phonetextcolor',
		array(
		    'label'   		=> __('Phone Text Color','pool-cleaning'),
		    'section'		=> 'top_header',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	
	$wp_customize->register_control_type('poolcleaning_Tab_Control');
	$wp_customize->register_panel_type( 'poolcleaning_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'poolcleaning_WP_Customize_Section' );

}
add_action( 'customize_register', 'poolcleaning_header_settings' );


if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class poolcleaning_WP_Customize_Panel extends WP_Customize_Panel {
	   public $panel;
	   public $type = 'poolcleaning_panel';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class poolcleaning_WP_Customize_Section extends WP_Customize_Section {
	   public $section;
	   public $type = 'poolcleaning_section';
	   public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}

