<?php
function poolcleaning_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'poolcleaning_frontpage_sections', array(
			'priority' => 32,
			'title' => esc_html__( 'Frontpage Sections', 'pool-cleaning' ),
		)
	);
	

	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'pool-cleaning' ),
			'priority' => 13,
			'panel' => 'poolcleaning_frontpage_sections',
		)
	);
	
	
	$wp_customize->add_setting('poolcleaning_reset_slider_settings',array(
		'sanitize_callback'   => 'sanitize_text_field'
	));
	$wp_customize->add_control(new poolcleaning_Reset_Custom_Control($wp_customize, 'pool_cleaning_reset_slider_settings',array(
		'type' => 'reset_control',
			'priority' => 1,
		'label' => __('Reset slider Settings', 'pool-cleaning'),
		'description' => 'pool_cleaning_slider_reset_settings',
		'section' => 'slider_setting'
	)));
  
  
  
	$wp_customize->add_setting('poolcleaning_top_slider_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new poolcleaning_Tab_Control($wp_customize, 'poolcleaning_top_slider_tabs', array(
		'section' => 'slider_setting',
		'priority' => 2,
		'buttons' => array(
		array(
			'name' => esc_html__('General', 'pool-cleaning'),
			'icon' => 'dashicons dashicons-welcome-write-blog',
			'fields' => array(
				'slider1',
				'slider2',
				'slider3',
				'slider4',
				'slider5',
				'slider6'

			),
			'active' => true,
		),
		array(
			'name' => esc_html__('Style', 'pool-cleaning'),
			'icon' => 'dashicons dashicons-art',
			'fields' => array(
				'slider_titlecolor',
				'slider_descriptioncolor',
				'slider_buttontextcolor',
				'slider_btnbgcolor',
				'slider_btntexthovrcolor',
				'slider_btnbghrvcolor',
				'slider_arrowiconcolor',
				'slider_arrowbgcolor',
				'slider_arrowbghrvcolor'
			),
		)
		
		),
	)));


	//general

	// Slider 1
	$wp_customize->add_setting( 
    	'slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'slider1',
		array(
		    'label'   		=> __('Slider 1','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Slider 2
	$wp_customize->add_setting(
    	'slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'slider2',
		array(
		    'label'   		=> __('Slider 2','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider3',
		array(
		    'label'   		=> __('Slider 3','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 4
	$wp_customize->add_setting(
    	'slider4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'slider4',
		array(
		    'label'   		=> __('Slider 4','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Slider 5
	$wp_customize->add_setting(
    	'slider5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'slider5',
		array(
		    'label'   		=> __('Slider 5','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	//style

	// slider text Color
	$slidertextcolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_titlecolor',
    	array(
			'default' => $slidertextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_titlecolor',
		array(
		    'label'   		=> __('Title Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider description Color
	$sliderdescriptioncolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_descriptioncolor',
    	array(
			'default' => $sliderdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider buttontext Color
	$sliderbuttontextcolor = esc_html__('#2e1f0c', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_buttontextcolor',
    	array(
			'default' => $sliderbuttontextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_buttontextcolor',
		array(
		    'label'   		=> __('Button Text Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btnbg Color
	$sliderbtnbgcolor = esc_html__('#ffbb3c', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_btnbgcolor',
    	array(
			'default' => $sliderbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btntexthovr Color
	$sliderbtntexthovrcolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_btntexthovrcolor',
    	array(
			'default' => $sliderbtntexthovrcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntexthovrcolor',
		array(
		    'label'   		=> __('Button Text Hover Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider btnbghrv Color
	$sliderbtnbghrvcolor = esc_html__('#002c8b', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_btnbghrvcolor',
    	array(
			'default' => $sliderbtnbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbghrvcolor',
		array(
		    'label'   		=> __('Button BG Hover Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider arrowicon Color
	$sliderarrowiconcolor = esc_html__('#000', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_arrowiconcolor',
    	array(
			'default' => $sliderarrowiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowiconcolor',
		array(
		    'label'   		=> __('Arrows Icon Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider arrowbg Color
	$sliderarrowbgcolor = esc_html__('#fff', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_arrowbgcolor',
    	array(
			'default' => $sliderarrowbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowbgcolor',
		array(
		    'label'   		=> __('Arrows BG Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	

	// slider arrowbghrv Color
	$sliderarrowbghrvcolor = esc_html__('#ffbb3c', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'slider_arrowbghrvcolor',
    	array(
			'default' => $sliderarrowbghrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'slider_arrowbghrvcolor',
		array(
		    'label'   		=> __('Arrows BG Hover Color','pool-cleaning'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	/*=========================================
	Service Section
	=========================================*/
	$wp_customize->add_section(
		'Service_setting', array(
			'title' => esc_html__( 'Service Section', 'pool-cleaning' ),
			'priority' => 14,
			'panel' => 'poolcleaning_frontpage_sections',
		)
	);

	$wp_customize->add_setting('poolcleaning_reset_Service_settings',array(
		'sanitize_callback'   => 'sanitize_text_field'
	));
	$wp_customize->add_control(new poolcleaning_Reset_Custom_Control($wp_customize, 'pool_cleaning_reset_Service_settings',array(
		'type' => 'reset_control',
			'priority' => 1,
		'label' => __('Reset Service Settings', 'pool-cleaning'),
		'description' => 'pool_cleaning_Service_reset_settings',
		'section' => 'Service_setting'
	)));
  
  
  
	$wp_customize->add_setting('poolcleaning_top_Service_tabs', array(
		'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new poolcleaning_Tab_Control($wp_customize, 'poolcleaning_top_Service_tabs', array(
		'section' => 'Service_setting',
		'priority' => 2,
		'buttons' => array(
		array(
			'name' => esc_html__('General', 'pool-cleaning'),
			'icon' => 'dashicons dashicons-welcome-write-blog',
			'fields' => array(
				'Service1',
				'Service2',
				'Service3',
				'Service4',
				'Service5',
				'Service6'

			),
			'active' => true,
		),
		array(
			'name' => esc_html__('Style', 'pool-cleaning'),
			'icon' => 'dashicons dashicons-art',
			'fields' => array(
				'Service_subheadingcolor',
				'Service_headingcolor'
			),
		)
		
		),
	)));



	// Service 1
	$wp_customize->add_setting( 
    	'Service1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'Service1',
		array(
		    'label'   		=> __('Service 1','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Service 2
	$wp_customize->add_setting(
    	'Service2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'Service2',
		array(
		    'label'   		=> __('Service 2','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 3
	$wp_customize->add_setting(
    	'Service3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'Service3',
		array(
		    'label'   		=> __('Service 3','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service 4
	$wp_customize->add_setting(
    	'Service4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'Service4',
		array(
		    'label'   		=> __('Service 4','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Service 5
	$wp_customize->add_setting(
    	'Service5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service5',
		array(
		    'label'   		=> __('Service 5','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	// Service 6
	$wp_customize->add_setting(
    	'Service6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'Service6',
		array(
		    'label'   		=> __('Service 6','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	//style

	// Service subheading Color
	$Servicesubheadingcolor = esc_html__('#4db5e7', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'Service_subheadingcolor',
    	array(
			'default' => $Servicesubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'Service_subheadingcolor',
		array(
		    'label'   		=> __('Sub Heading & Border Color','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	


	// Service heading Color
	$Serviceheadingcolor = esc_html__('#000', 'pool-cleaning' );
	$wp_customize->add_setting(
    	'Service_headingcolor',
    	array(
			'default' => $Serviceheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      =>11,
		)
	);	

	$wp_customize->add_control( 
		'Service_headingcolor',
		array(
		    'label'   		=> __('Heading Color','pool-cleaning'),
		    'section'		=> 'Service_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);	



}

add_action( 'customize_register', 'poolcleaning_blog_setting' );

// service selective refresh
function poolcleaning_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'poolcleaning_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'poolcleaning_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'poolcleaning_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'poolcleaning_blog_section_partials' );

// blog_title
function poolcleaning_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function poolcleaning_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// service description
function poolcleaning_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}