<?php
function poolcleaning_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'poolcleaning_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'fbfcfc',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'poolcleaning_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'poolcleaning_custom_header_setup' );

if ( ! function_exists( 'poolcleaning_header_style' ) ) :

function poolcleaning_header_style() {
	$header_text_color = get_header_textcolor();

	?>
	<style type="text/css">


		h4.site-title {
			color: <?php echo esc_attr(get_theme_mod('header_sitetitlecolor')); ?> !important;
		}

		p.site-description {
			color: <?php echo esc_attr(get_theme_mod('header_sitetaglinecolor')); ?> !important;
		}

		.main-header .navbar .navbar-menu ul li a {
			color: <?php echo esc_attr(get_theme_mod('header_menucolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			color: <?php echo esc_attr(get_theme_mod('header_submenutextcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu {
			background: <?php echo esc_attr(get_theme_mod('header_submenubgcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:hover {
			color: <?php echo esc_attr(get_theme_mod('header_submenutexthovercolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:hover {
			background: <?php echo esc_attr(get_theme_mod('header_submenubghovercolor')); ?>;
		}

		.col-space-icon i {
			color: <?php echo esc_attr(get_theme_mod('header_phoneiconcolor')); ?>;
		}

		.col-space-icon i {
			background: <?php echo esc_attr(get_theme_mod('header_phoneiconbgcolor')); ?>;
		}

		p.poolcleaning-phone-label {
			color: <?php echo esc_attr(get_theme_mod('header_phonetextcolor')); ?>;
		}

		




		.main-header .socials i {
			color: <?php echo esc_attr(get_theme_mod('header_iconcolor')); ?>;
		}

		.main-header .socials i {
			background: <?php echo esc_attr(get_theme_mod('header_iconbgcolor')); ?>;
		}





		.hero-style .slide-title h2 {
			color: <?php echo esc_attr(get_theme_mod('slider_titlecolor')); ?>;
		}

		.hero-style .slide-text p {
			color: <?php echo esc_attr(get_theme_mod('slider_descriptioncolor')); ?>;
		}

		.hero-style a.ReadMore {
			color: <?php echo esc_attr(get_theme_mod('slider_buttontextcolor')); ?> !important;
		}

		.hero-style a.ReadMore {
			background: <?php echo esc_attr(get_theme_mod('slider_btnbgcolor')); ?> !important;
		}

		.hero-style a.ReadMore:hover {
			color: <?php echo esc_attr(get_theme_mod('slider_btntexthovrcolor')); ?> !important;
		}

		.hero-style a.ReadMore:hover {
			background: <?php echo esc_attr(get_theme_mod('slider_btnbghrvcolor')); ?> !important;
		}

		.hero-slider .swiper-button-prev:before, .hero-slider .swiper-button-next:before {
			color: <?php echo esc_attr(get_theme_mod('slider_arrowiconcolor')); ?> !important;
		}

		.hero-slider .swiper-button-prev:before,.hero-slider .swiper-button-next:before {
			background: <?php echo esc_attr(get_theme_mod('slider_arrowbgcolor')); ?> !important;
		}

		.hero-slider .swiper-button-prev:hover:before, .hero-slider .swiper-button-next:hover:before {
			background: <?php echo esc_attr(get_theme_mod('slider_arrowbghrvcolor')); ?> !important;
		}



		/* service */

		#service-section .header-section .title{
			color: <?php echo esc_attr(get_theme_mod('Service_subheadingcolor')); ?> !important;
		}

		#service-section .progress svg path{
			stroke: <?php echo esc_attr(get_theme_mod('Service_subheadingcolor')); ?> !important;
		}

		#service-section .header-section .description{
			color: <?php echo esc_attr(get_theme_mod('Service_headingcolor')); ?> !important;
		}


		
	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		h4.site-title,
		p.site-description {
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif;
