<?php
if ( ! function_exists( 'poolcleaning_setup' ) ) :
function poolcleaning_setup() {

// Root path/URI.
define( 'POOLCLEANING_PARENT_DIR', get_template_directory() );
define( 'POOLCLEANING_PARENT_URI', get_template_directory_uri() );

// Root path/URI.
define( 'POOLCLEANING_PARENT_INC_DIR', POOLCLEANING_PARENT_DIR . '/inc');
define( 'POOLCLEANING_PARENT_INC_URI', POOLCLEANING_PARENT_URI . '/inc');

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 */
	add_theme_support( 'title-tag' );
	
	add_theme_support( 'custom-header' );
	
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );
	
	//Add selective refresh for sidebar widget
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	/*
	 * Make theme available for translation.
	 */
	load_theme_textdomain( 'pool-cleaning' );
		
	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary_menu' => esc_html__( 'Primary Menu', 'pool-cleaning' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	
	
	add_theme_support('custom-logo');

	/*
	 * WooCommerce Plugin Support
	 */
	add_theme_support( 'woocommerce' );
	
	// Gutenberg wide images.
	add_theme_support( 'align-wide' );
	
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'assets/css/editor-style.css', poolcleaning_google_font() ) );
	
	//Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'poolcleaning_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
}
endif;
add_action( 'after_setup_theme', 'poolcleaning_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function poolcleaning_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'poolcleaning_content_width', 1170 );
}
add_action( 'after_setup_theme', 'poolcleaning_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

function poolcleaning_widgets_init() {
	
	register_sidebar( array(
		'name' => __( 'Sidebar Widget Area', 'pool-cleaning' ),
		'id' => 'poolcleaning-sidebar-primary',
		'description' => __( 'The Primary Widget Area', 'pool-cleaning' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4><div class="title"><span class="shap"></span></div>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer Widget Area', 'pool-cleaning' ),
		'id' => 'poolcleaning-footer-widget-area',
		'description' => __( 'The Footer Widget Area', 'pool-cleaning' ),
		'before_widget' => '<div class="footer-widget col-lg-3 col-sm-6 wow fadeIn" data-wow-delay="0.2s"><aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside></div>',
		'before_title' => '<h5 class="widget-title w-title">',
		'after_title' => '</h5><span class="shap"></span>',
	) );

	register_sidebar( array(
		'name' => __( 'WooCommerce Widget Area', 'pool-cleaning' ),
		'id' => 'poolcleaning-woocommerce-sidebar',
		'description' => __( 'This Widget area for WooCommerce Widget', 'pool-cleaning' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4><div class="title"><span class="shap"></span></div>',
	) );
}
add_action( 'widgets_init', 'poolcleaning_widgets_init' );

/**
 * All Styles & Scripts.
 */

require_once get_template_directory() . '/inc/enqueue.php';

/**
 * Nav Walker fo Bootstrap Dropdown Menu.
 */

require_once get_template_directory() . '/inc/class-wp-bootstrap-navwalker.php';

/**
 * Implement the Custom Header feature.
 */
require_once get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require_once get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require_once get_template_directory() . '/inc/extras.php';


/**
 * Customizer additions.
 */
 require_once get_template_directory() . '/inc/poolcleaning-customizer.php';

require_once get_template_directory() . '/inc/tab-control.php';


// for header
function pool_cleaning_header_reset_settings() {
	remove_theme_mod('hide_show_sticky');
    remove_theme_mod('topheader_phn');
    remove_theme_mod('topheader_phnicon');
    remove_theme_mod('header_icon1');
    remove_theme_mod('header_icon2');
    remove_theme_mod('header_icon3');
    remove_theme_mod('header_icon4');
    remove_theme_mod('header_iconcolor');
	remove_theme_mod('header_iconbgcolor');
    wp_send_json_success(
        array(
            'success' => true,
            'message' => "Reset Completed",
        )
    );
}
add_action( 'wp_ajax_pool_cleaning_header_reset_settings', 'pool_cleaning_header_reset_settings' );


// for slider
function pool_cleaning_slider_reset_settings() {
	remove_theme_mod('slider1');
    remove_theme_mod('slider2');
    remove_theme_mod('slider3');
    remove_theme_mod('slider4');
    remove_theme_mod('slider5');
    remove_theme_mod('slider6');
    remove_theme_mod('slider_titlecolor');
    remove_theme_mod('slider_descriptioncolor');
	remove_theme_mod('slider_buttontextcolor');
    remove_theme_mod('slider_btnbgcolor');
    remove_theme_mod('slider_btntexthovrcolor');
    remove_theme_mod('slider_btnbghrvcolor');
	remove_theme_mod('slider_arrowiconcolor');
    remove_theme_mod('slider_arrowbgcolor');
    remove_theme_mod('slider_arrowbghrvcolor');
    wp_send_json_success(
        array(
            'success' => true,
            'message' => "Reset Completed",
        )
    );
}
add_action( 'wp_ajax_pool_cleaning_slider_reset_settings', 'pool_cleaning_slider_reset_settings' );



// for Service
function pool_cleaning_Service_reset_settings() {
	remove_theme_mod('Service1');
    remove_theme_mod('Service2');
    remove_theme_mod('Service3');
    remove_theme_mod('Service4');
    remove_theme_mod('Service5');
    remove_theme_mod('Service6');
    remove_theme_mod('Service_headingcolor');
	remove_theme_mod('Service_subheadingcolor');
    wp_send_json_success(
        array(
            'success' => true,
            'message' => "Reset Completed",
        )
    );
}
add_action( 'wp_ajax_pool_cleaning_Service_reset_settings', 'pool_cleaning_Service_reset_settings' );


add_filter( 'nav_menu_link_attributes', 'poolcleaning_dropdown_data_attribute', 20, 3 );
/**
 * Use namespaced data attribute for Bootstrap's dropdown toggles.
 *
 * @param array    $atts HTML attributes applied to the item's `<a>` element.
 * @param WP_Post  $item The current menu item.
 * @param stdClass $args An object of wp_nav_menu() arguments.
 * @return array
 */
function poolcleaning_dropdown_data_attribute( $atts, $item, $args ) {
    if ( is_a( $args->walker, 'WP_Bootstrap_Navwalker' ) ) {
        if ( array_key_exists( 'data-toggle', $atts ) ) {
            unset( $atts['data-toggle'] );
            $atts['data-bs-toggle'] = 'dropdown';
        }
    }
    return $atts;
}

